/*
$("#submit-button").on("click", function (event) {
    event.preventDefault();
    var myForm = $("#email-form");
    submitForm(myForm);
});

function submitForm($form) {
    // Initiate Variables With Form Content
    $.ajax({
        type: $form.attr("method"),
        url: $form.attr("action"),
        data: $form.serialize(),
        success: function (text) {
            if (text.status == "success") {
                document.getElementById("email-form").reset();
                formSuccess();
            } else {
                formError();
            }
        },
    });
}

function formError() {
    $(".w-form-fail").show();
}

function formSuccess(valid, msg) {
    $(".w-form-done").show();
}
*/

// Funcion nuevas del CRM
const Webkey = 'GXJTB-004B0-OB4L4-4OYR3-GB0IL';
const Page  = '14';
const Company = '1052';
const Subscriptor = '27';

$(document).ready(function() {

    // Generar dos números aleatorios para el CAPTCHA
    let num1 = Math.floor(Math.random() * 10) + 1;
    let num2 = Math.floor(Math.random() * 10) + 1;

    // Mostrar los números en el HTML
    $('#num1').text(num1);
    $('#num2').text(num2);

    document.getElementById("email-form").reset();

    $.getJSON('https://ipapi.co/json/', function (data) {
        localStorage.setItem('Ip', data.ip);
        localStorage.setItem('Country', data.country_code_iso3);
        localStorage.setItem('State',  data.region_code);
        localStorage.setItem('City', data.city)

        start();
    })
});

function start(){

    let pscode = localStorage.getItem('Pscode');
    let ip = localStorage.getItem('Ip');
    let city = localStorage.getItem('City');
 
    $.ajax({
        url: 'https://api.cycmanager.mx/api/Sessionpage/CheckSession', 
        type: 'POST',
        contentType: 'application/json', 
        data: JSON.stringify({
            Webkey : Webkey,
            Pscode : pscode,
            Page : Page,
            Ips : ip,
            Company : Company,
            Subscriptor : Subscriptor,
            City : city
        }),
        success: function(response) {
            localStorage.setItem('Pscode', response);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            //console.log('Error en la solicitud:', textStatus, errorThrown);
        }
    });
}

$("#btn_submit").on("click", function (event) {
    event.preventDefault();
    
    if (validateCaptcha() && validateRequiredFields('email-form')) {
        addCRM();
    } else {

    }
});


function validateCaptcha() {
    // Obtener el valor ingresado en el campo CAPTCHA
    let captchaInput = parseInt($('#captcha-input').val());

    // Validar si la suma es correcta
    let num1 = parseInt(document.getElementById('num1').textContent, 10);
    let num2 = parseInt(document.getElementById('num2').textContent, 10);

    if (captchaInput === num1 + num2) {
        $(".captcha-error").hide();
        return true;  // CAPTCHA correcto
    } else {
        $(".captcha-error").show();
        return false;  // CAPTCHA incorrecto
    }
}

function validateRequiredFields(formId) {
    // Obtener el formulario por su ID
    let form = document.getElementById(formId);
    
    // Obtener todos los campos que tienen el atributo required
    let requiredFields = form.querySelectorAll('[required]');
    
    // Variable para controlar el estado de validación
    let allValid = true;
    
    // Recorrer cada campo y verificar si está lleno
    requiredFields.forEach(function(field) {
        if (!field.value.trim()) {
            allValid = false;  // Si el campo está vacío, cambiar allValid a false
            // Opcional: puedes agregar un mensaje de error o un borde rojo a los campos vacíos
            field.style.border = '.5px solid red';
            $(".inputs-ok").show();
        } else {
            // Limpiar los estilos si el campo está lleno
            field.style.border = '';
            $(".inputs-ok").hide();
        }
    });
    
    // Devolver true si todos los campos están completos, de lo contrario false
    return allValid;
}

function addCRM(){
    let nickname = document.getElementById('name').value;
    let email = document.getElementById('email').value;
    let phone = document.getElementById('phone_number').value;
    
    let body = 'Hola, estoy interesado en un';
    var chks = $('input[name="interes"]:checked').val();
    
    if(chks === '0'){
        body += ' RANCHO URBANO .';
    }else{
        body += ' LOTE REGULAR .';
    }

    let area = document.getElementById('area').value; 
    let comentarios = document.getElementById('comment').value; 

    body += ' Soy del area de ' + area + '. Comentarios: ' + comentarios; 

    var formData = new FormData();

    formData.append("Email", email);
    formData.append("Nickname", nickname);
    formData.append("Subject", '');
    formData.append("Body", body);
    formData.append("Phone", phone);

    formData.append("Pscode", localStorage.getItem('Pscode'));

    formData.append("Page", Page);

    formData.append("Ips", localStorage.getItem('Ip'));
    //formData.append("Ips", '');

    formData.append("Countryip", localStorage.getItem('Country'));
    formData.append("Stateip", localStorage.getItem('State'));
    formData.append("Cityip", localStorage.getItem('City'));
    formData.append("Webkey", Webkey);
    formData.append("Subscriptor", Subscriptor);
    formData.append("Company", Company);

    formData.append("Sendcrm", '1');
    formData.append("Sendemail", '1');

    var xhr = new XMLHttpRequest();
    xhr.open("POST", "https://api.cycmanager.mx/api/Contact/Send", true);

        // Manejar la respuesta
        xhr.onload = function () {
            if (xhr.status === 200) {
                $(".w-form-done").show();
                $("#email-form").hide();

            } else {
                $(".w-form-fail").show();
            }
        };
    
    // Enviar el formulario
    xhr.send(formData);

    //console.log(formData);
}

$("#copyLink").on("click", function() {
    var tempInput = $("<input>");
    $("body").append(tempInput);
    tempInput.val("3316705776").select();
    document.execCommand("copy");
    tempInput.remove();
    //alert("Número copiado: 523316705776");
    showToast('Teléfono copiado');
});

function showToast(message) {
    var toast = document.getElementById("toast");
    var toastMessage = document.getElementById("toast-message");
    
    toastMessage.innerHTML = message;
    toast.className = "toast show";
  
    // Ocultar el toast después de 3 segundos
    setTimeout(function() {
      toast.className = toast.className.replace("show", "");
    }, 3000);
  }