const Webkey = 'GXJTB-004B0-OB4L4-4OYR3-GB0IL';
const Page  = '14';
const Company = '1052';
const Subscriptor = '27';

$(document).ready(function() {

    // Generar dos números aleatorios para el CAPTCHA
    let num1 = Math.floor(Math.random() * 10) + 1;
    let num2 = Math.floor(Math.random() * 10) + 1;

    // Mostrar los números en el HTML
    $('#num1').text(num1);
    $('#num2').text(num2);

    document.getElementById("email-form").reset();

    $.getJSON('https://ipapi.co/json/', function (data) {
        localStorage.setItem('Ip', data.ip);
        localStorage.setItem('Country', data.country_code_iso3);
        localStorage.setItem('State',  data.region_code);
        localStorage.setItem('City', data.city)

        start();
    })
});

function start(){

    let pscode = localStorage.getItem('Pscode');
    let ip = localStorage.getItem('Ip');
    let city = localStorage.getItem('City');
 
    $.ajax({
        url: 'https://api.cycmanager.mx/api/Sessionpage/CheckSession', 
        type: 'POST',
        contentType: 'application/json', 
        data: JSON.stringify({
            Webkey : Webkey,
            Pscode : pscode,
            Page : Page,
            Ips : ip,
            Company : Company,
            Subscriptor : Subscriptor,
            City : city
        }),
        success: function(response) {
            localStorage.setItem('Pscode', response);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            //console.log('Error en la solicitud:', textStatus, errorThrown);
        }
    });
}

$("#btn_submit").on("click", function (event) {
    event.preventDefault();
    
    if (validateCaptcha() && validateRequiredFields('email-form')) {
        addCRM();
    } else {

    }
});

function validateCaptcha() {
    // Obtener el valor ingresado en el campo CAPTCHA
    let captchaInput = parseInt($('#captcha-input').val());

    // Validar si la suma es correcta
    let num1 = parseInt(document.getElementById('num1').textContent, 10);
    let num2 = parseInt(document.getElementById('num2').textContent, 10);

    if (captchaInput === num1 + num2) {
        return true;  // CAPTCHA correcto
    } else {
        Swal.fire({
            title: 'Atención',
            text: 'Valide el captcha para continuar',
            icon: 'warning',
            confirmButtonColor: '#aab28e', 
            confirmButtonText: 'OK'
        });
        return false;  // CAPTCHA incorrecto
    }
}

function validateRequiredFields(formId) {
    let form = document.getElementById(formId);
    let requiredFields = form.querySelectorAll('[required]');
    let allValid = true;

    requiredFields.forEach(function (field) {
        const value = field.value.trim();
        const type = field.getAttribute('type') || field.tagName.toLowerCase(); // Para campos como textarea
        let isValid = true;

        // Validación básica de contenido vacío
        if (!value) {
            isValid = false;
        } else {
            // Validación por tipo
            if (type === "email") {
                const regexCorreo = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                isValid = regexCorreo.test(value);
            }

            if (type === "tel") {
                const regexTelefono = /^[0-9]{10}$/;
                isValid = regexTelefono.test(value);
            }
        }

        if (!isValid) {
            allValid = false;
            field.style.border = '.5px solid red';
            Swal.fire({
                title: 'Atención',
                text:
                    type === "email"
                        ? 'Ingresa un correo electrónico válido.'
                        : type === "tel"
                        ? 'El número telefónico debe tener 10 dígitos.'
                        : 'Faltan llenar algunos datos.',
                icon: 'warning',
                confirmButtonColor: '#aab28e',
                confirmButtonText: 'OK'
            });
        } else {
            field.style.border = '';
        }
    });

    return allValid;
}

function addCRM(){
    let nickname = document.getElementById('name').value;
    let email = document.getElementById('email').value;
    let phone = document.getElementById('phone_number').value;
    
    let body = 'Hola, estoy interesado en un';
    var chks = $('input[name="interes"]:checked').val();
    
    if(chks === '0'){
        body += ' RANCHO URBANO .';
    }else{
        body += ' LOTE REGULAR .';
    }

    let area = document.getElementById('area').value; 
    let comentarios = document.getElementById('comment').value; 

    body += ' Soy del area de ' + area + '. Comentarios: ' + comentarios; 

    var formData = new FormData();

    formData.append("Email", email);
    formData.append("Nickname", nickname);
    formData.append("Subject", '');
    formData.append("Body", body);
    formData.append("Phone", phone);

    formData.append("Pscode", localStorage.getItem('Pscode'));

    formData.append("Page", Page);

    formData.append("Ips", localStorage.getItem('Ip'));
    //formData.append("Ips", '');

    formData.append("Countryip", localStorage.getItem('Country'));
    formData.append("Stateip", localStorage.getItem('State'));
    formData.append("Cityip", localStorage.getItem('City'));
    formData.append("Webkey", Webkey);
    formData.append("Subscriptor", Subscriptor);
    formData.append("Company", Company);

    formData.append("Sendcrm", '1');
    formData.append("Sendemail", '1');

    var xhr = new XMLHttpRequest();
    xhr.open("POST", "https://api.cycmanager.mx/api/Contact/Send", true);

        // Manejar la respuesta
        xhr.onload = function () {
            if (xhr.status === 200) {
                Swal.fire({
                    title: 'Gracias por contactarnos',
                    text: 'Pronto recibirás noticias nuestras.',
                    icon: 'success',
                    confirmButtonColor: '#aab28e', 
                    confirmButtonText: 'OK'
                });
            } else {
                Swal.fire({
                    title: 'Error',
                    text: 'Ocurrió un error mientras se procesaba la petición, por favor vuelva a intentar',
                    icon: 'error',
                    confirmButtonColor: '#aab28e', 
                    confirmButtonText: 'OK'
                });
            }
        };
    
    // Enviar el formulario
    xhr.send(formData);
    
    //console.log(formData);
}

$(".btn-contactanos, .btn-contactanoss").on("click", function (event) {

    event.preventDefault();

    let target = $("#CONTACTO");

    if (target.length) {
        $("html, body").animate({
            scrollTop: target.offset().top
        }, 2000); 
    }
});

$(".btn-inicio").on("click", function (event) {
    $("html, body").animate({ scrollTop: 0 }, 800);
});

